/*******************************************************
Filename		:  estry_tables.sql
Release 		:  c2.0
SIR			:  1473
Description		:  Estuary look up table and related object creation.  This object will be used for reporting.
Author			:  Ganesh Thadkamalla
Date			:  10/01/2002
			   09/02/2003 -- remove null values from look-up tables -JW
			   01/16/04 - SIR 1586 Moved connect string to master install script -JW
--12/27/2007 added Kevin changes and commented out the fa_station_map and fa_station_wweb table DDL and DML statements. Defect# 987
Comments		:  
**********************************************************/

set echo on;
spool  estry_tables.log

drop sequence seq_estry_primary;
drop sequence seq_estry_secondary;

create sequence seq_estry_primary
start with 1 increment by 1 nomaxvalue nocycle cache 10;

create sequence seq_estry_secondary
start with 1 increment by 1 nomaxvalue nocycle cache 10;

drop table lu_estry_primary;
create table lu_estry_primary
(pk_isn number(12,0),
 primary_estuary varchar2(30)
);

drop table lu_estry_secondary;
create table lu_estry_secondary
(pk_isn number(12,0),
 secondary_estuary varchar2(30)
);

alter table lu_estry_primary
add constraint pk_estry_primary primary key (pk_isn)
using index
tablespace STORETINDX
storage (initial  100K next 100K)
nologging;

alter table lu_estry_secondary
add constraint pk_estry_secondary primary key (pk_isn)
using index
tablespace STORETINDX
storage (initial  100K next 100K)
nologging;

--add data to lu_estry_primary
set serveroutput on
declare
cursor c1 is select distinct primary_estuary from fa_station
	where primary_estuary is not null;

begin
for c1_var in c1 loop
insert into lu_estry_primary (pk_isn,primary_estuary)
values(seq_estry_primary.nextval,c1_var.primary_estuary);
end loop;
commit;
end;
/

--add data to lu_estry_secondary
set serveroutput on
declare
cursor c1 is select distinct secondary_estuary from fa_station
	where secondary_estuary is not null;

begin
for c1_var in c1 loop
insert into lu_estry_secondary (pk_isn,secondary_estuary )
values(seq_estry_secondary.nextval,c1_var.secondary_estuary);
end loop;
commit;
end;
/
commit;
create index iestry_primary01 on lu_estry_primary(primary_estuary)
tablespace STORETINDX
storage (initial 100K next 100K)
nologging;

create index iestry_secondary01 on lu_estry_secondary(secondary_estuary)
tablespace STORETINDX
storage (initial 100K next 100K)
nologging;

-- add fk to fa_station

alter table fa_station
add (fk_estry_primary number(12,0),
     fk_estry_secondary number(12,0));

--update fks in fa_station

declare
cursor c1 is select * from lu_estry_primary;
cursor c2 is select * from lu_estry_secondary;

begin
for c1_var in c1 loop
update fa_station 
set fk_estry_primary = c1_var.pk_isn
where primary_estuary = c1_var.primary_estuary
  and primary_estuary is not null;
end loop;
commit;

for c2_var in c2 loop
update fa_station 
set fk_estry_secondary = c2_var.pk_isn
where secondary_estuary = c2_var.secondary_estuary 
 and  secondary_estuary is not null;
end loop;
commit;
end;
/
--fks in fa_station
alter table fa_station
add constraint fk_sd_estry_primary foreign key (fk_estry_primary) references lu_estry_primary(pk_isn);
alter table fa_station
add constraint fk_sd_estry_secondary foreign key (fk_estry_secondary) references lu_estry_secondary(pk_isn);


--indexes on fks in fa_station
create index isd_fk_estry_primary on fa_station(fk_estry_primary)
tablespace STORETINDX
storage (initial 500K next 500K)
nologging;

create index isd_fk_estry_secondary on fa_station(fk_estry_secondary)
tablespace STORETINDX
storage (initial 500K next 500K)
nologging;

--
/*  
drop table FA_STATION_WEB;
drop table FA_STATION_MAP;
--
create table FA_STATION_WEB
tablespace storetdata
storage (initial 25M next 25M)
as
SELECT 
FA.ORGANIZATION_ID "Org ID", FA.STATION_ID "Station ID", 
FA.STATION_NAME "Station Name", og.ORGANIZATION_NAME "Org Name", st.PRIMARY_TYPE 
"Primary Type", st.SECONDARY_TYPE "Secondary Type", FA.SGO_INDICATOR "S/G/O Indicator", 
FA.WELL_NUMBER "Well Number", FA.WELL_NAME "Well Name", FA.PIPE_NUMBER "Pipe Number", 
FA.NAICS_CODE "NAICS Code", FA.SPRING_TYPE_IMPROVEMENT "Spring Type Improvement", 
FA.SPRING_PERMANENCE "Permanence", FA.SPRING_USGS_GEOLOGIC_UNIT "USGS Geologic Unit Code-Name", 
FA.SPRING_OTHER_NAME "Spring Other Name", FA.SPRING_USGS_LITHOLOGIC_UNIT 
"USGS Lithologic Unit Code-Name", FA.LOCATION_POINT_TYPE "Location Point Type", 
FA.POINT_SEQUENCE_NUMBER "Point Sequence Number", FA.POINT_NAME "Point Name", 
FA.LATITUDE "Latitude", FA.LONGITUDE "Longitude", hd.HORIZONTAL_DATUM "Horizontal Datum", 
FA.STD_LATITUDE "Converted Latitude", FA.STD_LONGITUDE "Converted Longitude", hds.HORIZONTAL_DATUM "Converted Horizontal Datum",
hm.GEOPOSITIONING_METHOD "Geopositioning Method", FA.MAP_SCALE "Map Scale", 
FA.ELEVATION "Elevation", vd.ELEVATION_DATUM "Elevation Datum", vm.ELEVATION_METHOD 
"Elevation Method", COUNTRY_NAME "Country Name", gs.STATE_NAME "State", gc.COUNTY_NAME 
"County", ca.HYDROLOGIC_UNIT_CODE "Hydrologic Unit Code", ca.HYDROLOGIC_UNIT_NAME 
"Hydrologic Unit Name", cag.HYDROLOGIC_UNIT_CODE "Generated Hydrologic Unit Code", cag.HYDROLOGIC_UNIT_NAME 
"Generated Hydrologic Unit Name", FA.RF1_SEGMENT_CODE "RF1 Segment Code", FA.RF1_SEGMENT_NAME 
"RF1 Segment Name", FA.RF1_MILEAGE "RF1 Mileage", FA.ON_REACH_IND "On Reach Ind", 
FA.NRCS_WATERSHED_ID "NRCS Watershed ID", ep.PRIMARY_ESTUARY "Primary Estuary", 
es.SECONDARY_ESTUARY "Secondary Estuary", FA.OTHER_ESTUARY_NAME "Other Estuary Name", 
FA.GREAT_LAKE_NAME "Great Lake Name", FA.OCEAN_NAME "Ocean Name", 
FA.NATV_AMERICAN_LAND_NAME "Natv American Land Name", FA.FRS_KEY_IDENTIFIER 
"FRS Key Identifier", FA.DESCRIPTION_TEXT "Description Text"
FROM 
FA_STATION FA,DI_STATN_TYPES st,LU_MAD_HDATUM hd,LU_MAD_HDATUM hds,LU_MAD_HMETHOD hm,
LU_MAD_VDATUM vd,LU_MAD_VMETHOD vm,DI_GEO_STATE gs,DI_GEO_COUNTY gc,
DI_DB_CAT ca,DI_DB_CAT cag,LU_ESTRY_PRIMARY ep,LU_ESTRY_SECONDARY es,DI_ORG og
WHERE 
FA.fk_org = og.pk_isn (+) AND FA.fk_gen_db_cat = cag.pk_isn (+) AND 
FA.fk_db_cat = ca.pk_isn (+) AND FA.fk_estry_primary = ep.pk_isn (+) AND 
FA.fk_estry_secondary = es.pk_isn (+) AND fk_statn_types = st.pk_isn (+) AND 
fk_mad_hdatum = hd.pk_isn (+) AND fk_std_hdatum = hds.pk_isn (+) AND 
fk_mad_hmethod = hm.pk_isn (+) AND 
FA.fk_mad_vdatum = vd.pk_isn (+) AND FA.fk_mad_vmethod = vm.pk_isn (+) AND 
FA.fk_geo_state = gs.pk_isn (+) AND FA.fk_geo_county = gc.pk_isn (+)  AND
FA.LOCATION_POINT_TYPE='*POINT OF RECORD' ;

select count(*) station_count from storetw.fa_station_web;

drop table FA_STATION_MAP;
create table FA_STATION_MAP
tablespace storetdata
storage (initial 25M next 25M)
as
SELECT 
FA.ORGANIZATION_ID "Org ID", FA.STATION_ID "Station ID", 
FA.STATION_NAME "Station Name", og.ORGANIZATION_NAME "Org Name", st.PRIMARY_TYPE 
"Primary Type", st.SECONDARY_TYPE "Secondary Type", FA.SGO_INDICATOR "S/G/O Indicator", 
FA.WELL_NUMBER "Well Number", FA.WELL_NAME "Well Name", FA.PIPE_NUMBER "Pipe Number", 
FA.NAICS_CODE "NAICS Code", FA.SPRING_TYPE_IMPROVEMENT "Spring Type Improvement", 
FA.SPRING_PERMANENCE "Permanence", FA.SPRING_USGS_GEOLOGIC_UNIT "USGS Geologic Unit Code-Name", 
FA.SPRING_OTHER_NAME "Spring Other Name", FA.SPRING_USGS_LITHOLOGIC_UNIT 
"USGS Lithologic Unit Code-Name", FA.LOCATION_POINT_TYPE "Location Point Type", 
FA.POINT_SEQUENCE_NUMBER "Point Sequence Number", FA.POINT_NAME "Point Name", 
FA.STD_LATITUDE "Latitude", FA.STD_LONGITUDE "Longitude", hds.HORIZONTAL_DATUM "Horizontal Datum", 
FA.STD_LATITUDE "Converted Latitude", FA.STD_LONGITUDE "Converted Longitude", hds.HORIZONTAL_DATUM "Converted Horizontal Datum",
hm.GEOPOSITIONING_METHOD "Geopositioning Method", FA.MAP_SCALE "Map Scale", 
FA.ELEVATION "Elevation", vd.ELEVATION_DATUM "Elevation Datum", vm.ELEVATION_METHOD 
"Elevation Method", COUNTRY_NAME "Country Name", gs.STATE_NAME "State", gc.COUNTY_NAME 
"County", ca.HYDROLOGIC_UNIT_CODE "Hydrologic Unit Code", ca.HYDROLOGIC_UNIT_NAME 
"Hydrologic Unit Name", cag.HYDROLOGIC_UNIT_CODE "Generated Hydrologic Unit Code", cag.HYDROLOGIC_UNIT_NAME 
"Generated Hydrologic Unit Name", FA.RF1_SEGMENT_CODE "RF1 Segment Code", FA.RF1_SEGMENT_NAME 
"RF1 Segment Name", FA.RF1_MILEAGE "RF1 Mileage", FA.ON_REACH_IND "On Reach Ind", 
FA.NRCS_WATERSHED_ID "NRCS Watershed ID", ep.PRIMARY_ESTUARY "Primary Estuary", 
es.SECONDARY_ESTUARY "Secondary Estuary", FA.OTHER_ESTUARY_NAME "Other Estuary Name", 
FA.GREAT_LAKE_NAME "Great Lake Name", FA.OCEAN_NAME "Ocean Name", 
FA.NATV_AMERICAN_LAND_NAME "Natv American Land Name", FA.FRS_KEY_IDENTIFIER 
"FRS Key Identifier", FA.DESCRIPTION_TEXT "Description Text"
FROM 
FA_STATION FA,DI_STATN_TYPES st,LU_MAD_HDATUM hd,LU_MAD_HDATUM hds,LU_MAD_HMETHOD hm,
LU_MAD_VDATUM vd,LU_MAD_VMETHOD vm,DI_GEO_STATE gs,DI_GEO_COUNTY gc,
DI_DB_CAT ca,DI_DB_CAT cag,LU_ESTRY_PRIMARY ep,LU_ESTRY_SECONDARY es,DI_ORG og
WHERE 
FA.fk_org = og.pk_isn (+) AND FA.fk_gen_db_cat = cag.pk_isn (+) AND 
FA.fk_db_cat = ca.pk_isn (+) AND FA.fk_estry_primary = ep.pk_isn (+) AND 
FA.fk_estry_secondary = es.pk_isn (+) AND fk_statn_types = st.pk_isn (+) AND 
fk_mad_hdatum = hd.pk_isn (+) AND fk_std_hdatum = hds.pk_isn (+) AND 
fk_mad_hmethod = hm.pk_isn (+) AND 
FA.fk_mad_vdatum = vd.pk_isn (+) AND FA.fk_mad_vmethod = vm.pk_isn (+) AND 
FA.fk_geo_state = gs.pk_isn (+) AND FA.fk_geo_county = gc.pk_isn (+)  AND
FA.LOCATION_POINT_TYPE='*POINT OF RECORD' ;


drop table FA_STATION_MAP;
create table FA_STATION_MAP
tablespace storetdata
storage (initial 25M next 25M)
as
SELECT 
FA.ORGANIZATION_ID Org_ID, FA.STATION_ID Station_ID, 
FA.STATION_NAME Station_Name, og.ORGANIZATION_NAME Org_Name, st.PRIMARY_TYPE Primary_Type, 
st.SECONDARY_TYPE Secondary_Type,  FA.STD_LATITUDE Latitude, FA.STD_LONGITUDE Longitude, 
hds.HORIZONTAL_DATUM Horizontal_Datum, ca.HYDROLOGIC_UNIT_CODE HUC,
ca.HYDROLOGIC_UNIT_NAME Hydro_Unit_Name, cag.HYDROLOGIC_UNIT_CODE Generated_HUC
FROM 
FA_STATION FA,DI_STATN_TYPES st,LU_MAD_HDATUM hd,LU_MAD_HDATUM hds,LU_MAD_HMETHOD hm,
LU_MAD_VDATUM vd,LU_MAD_VMETHOD vm,DI_GEO_STATE gs,DI_GEO_COUNTY gc,
DI_DB_CAT ca,DI_DB_CAT cag,LU_ESTRY_PRIMARY ep,LU_ESTRY_SECONDARY es,DI_ORG og
WHERE 
FA.fk_org = og.pk_isn (+) AND FA.fk_gen_db_cat = cag.pk_isn (+) AND 
FA.fk_db_cat = ca.pk_isn (+) AND FA.fk_estry_primary = ep.pk_isn (+) AND 
FA.fk_estry_secondary = es.pk_isn (+) AND fk_statn_types = st.pk_isn (+) AND 
fk_mad_hdatum = hd.pk_isn (+) AND fk_std_hdatum = hds.pk_isn (+) AND 
fk_mad_hmethod = hm.pk_isn (+) AND 
FA.fk_mad_vdatum = vd.pk_isn (+) AND FA.fk_mad_vmethod = vm.pk_isn (+) AND 
FA.fk_geo_state = gs.pk_isn (+) AND FA.fk_geo_county = gc.pk_isn (+)  AND
FA.LOCATION_POINT_TYPE='*POINT OF RECORD' ;

ALTER TABLE fa_station_map 
set unused ("Description Text","FRS Key Identifier","Natv American Land Name","Ocean Name");
ALTER TABLE fa_station_map 
set unused ("Great Lake Name","Other Estuary Name","Secondary Estuary","Primary Estuary","NRCS Watershed ID","RF1 Segment Name","RF1 Mileage","On Reach Ind");
ALTER TABLE fa_station_map 
set unused ("RF1 Segment Code","County","State","Country Name","Elevation Method","Geopositioning Method","Map Scale","Elevation","Elevation Datum");
ALTER TABLE fa_station_map 
set unused ("Converted Latitude","Converted Longitude","Converted Horizontal Datum");
ALTER TABLE fa_station_map 
set unused ("S/G/O Indicator","Well Number","Well Name","Pipe Number","NAICS Code","Spring Type Improvement","Permanence","USGS Geologic Unit Code-Name"); 
ALTER TABLE fa_station_map 
set unused ("Spring Other Name","USGS Lithologic Unit Code-Name","Location Point Type","Point Sequence Number","Point Name");
select count(*) station_count from storetw.fa_station_map;
*/
spool off;